% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_score.R
\name{simplex_dist}
\alias{simplex_dist}
\title{The l_2 distance between a point and a simplex}
\usage{
simplex_dist(theta, V)
}
\arguments{
\item{theta}{A (K-1) dimensional vector, representing a point.}

\item{V}{The K-by-(K-1) vertices matrix, with each row being a vertex.}
}
\value{
The l_2 distance.
}
\description{
This function computes the l_2 distance between a point and a simplex, 
that is the shortest l_2 distance between the given point and any point in the simplex.
}
\examples{
# Generate 3 vertices
V <- rbind(c(-1/2,-1/2), c(1,0), c(0,1))

theta <- c(3,1)
simplex_dist(theta, V)
}
\references{
Ke, Z. T., & Wang, M. (2017). A new SVD approach to optimal topic estimation. arXiv preprint arXiv:1704.07016.
}
\author{
Minzhe Wang
}
