% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{as_yyyytt}
\alias{as_yyyytt}
\alias{as_yyyymm}
\title{Conversion au format date_ts}
\usage{
as_yyyytt(timeunits)

as_yyyymm(timeunits)
}
\arguments{
\item{timeunits}{une date en année (Par exemple 2015.25 pour le 2ème
trimestre 2015 ou \code{2021.83333333333} pour novembre 2021)}
}
\value{
En sortie, ces fonctions retournent la date au format \code{date_ts}
(c'est-à-dire un vecteur d'entiers de la forme \code{AAAA}, \code{c(AAAA, MM)} ou
\code{c(AAAA, TT)})
}
\description{
Les fonctions \code{as_yyyytt} et \code{as_yyyymm} convertissent une date
du format TimeUnits au format \code{date_ts}.
}
\details{
La fonction \code{as_yyyytt} retourne la date par trimestre et la fonction
\code{as_yyyymm} retourne la date par mois.
}
\examples{
as_yyyytt(2019.75) # 4ème trimestre 2019
as_yyyytt(2020) # 1er trimestre 2020
as_yyyytt(2022 + 1 / 4) # 2ème trimestre 2022

as_yyyymm(2019.75) # Octobre 2019
as_yyyymm(2020) # Janvier 2020
as_yyyymm(2020 + 1 / 12) # Février 2020
as_yyyymm(2020 + 12 / 12) # Janvier 2021

}
