% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnrichCircoBar.R
\name{enrich_circo_bar}
\alias{enrich_circo_bar}
\title{Combine and Visualize Data with Circular Bar Chart}
\usage{
enrich_circo_bar(data_list)
}
\arguments{
\item{data_list}{A list of data frames to be combined.}
}
\value{
A `ggplot` object representing the Circular Bar Chart.
}
\description{
This function combines multiple data frames, arranges them, and visualizes the combined data
in a Circular Bar Chart using the 'ggplot2' and 'ggalluvial' packages.
}
\examples{
# Create sample data frames for each enrichment category

# 1. Biological Process (BP)
filtered_data_BP <- data.frame(
  Description = c(
    "immune response",
    "cell proliferation",
    "signal transduction",
    "apoptotic process",
    "metabolic process"
  ),
  Count = c(120, 85, 150, 60, 95),
  color = c(
    "#1f77b4",  # blue
    "#ff7f0e",  # orange
    "#2ca02c",  # green
    "#d62728",  # red
    "#9467bd"   # purple
  ),
  stringsAsFactors = FALSE
)

# 2. Cellular Component (CC)
filtered_data_CC <- data.frame(
  Description = c(
    "nucleus",
    "cytoplasm",
    "membrane",
    "mitochondrion",
    "extracellular space"
  ),
  Count = c(90, 110, 75, 65, 80),
  color = c(
    "#1f77b4",
    "#ff7f0e",
    "#2ca02c",
    "#d62728",
    "#9467bd"
  ),
  stringsAsFactors = FALSE
)

# 3. Molecular Function (MF)
filtered_data_MF <- data.frame(
  Description = c(
    "protein binding",
    "DNA binding",
    "enzyme activity",
    "transporter activity",
    "receptor activity"
  ),
  Count = c(140, 130, 100, 70, 90),
  color = c(
    "#1f77b4",
    "#ff7f0e",
    "#2ca02c",
    "#d62728",
    "#9467bd"
  ),
  stringsAsFactors = FALSE
)

# 4. Disease Ontology (DO)
filtered_data_DO <- data.frame(
  Description = c(
    "cancer",
    "cardiovascular disease",
    "neurological disorder",
    "metabolic disease",
    "infectious disease"
  ),
  Count = c(200, 150, 120, 90, 160),
  color = c(
    "#1f77b4",
    "#ff7f0e",
    "#2ca02c",
    "#d62728",
    "#9467bd"
  ),
  stringsAsFactors = FALSE
)

# 5. Reactome Pathways
filtered_data_Reactome <- data.frame(
  Description = c(
    "Cell Cycle",
    "Apoptosis",
    "DNA Repair",
    "Signal Transduction",
    "Metabolism of Proteins"
  ),
  Count = c(110, 95, 80, 130, 85),
  color = c(
    "#1f77b4",
    "#ff7f0e",
    "#2ca02c",
    "#d62728",
    "#9467bd"
  ),
  stringsAsFactors = FALSE
)

# 6. KEGG Pathways
filtered_data_kegg <- data.frame(
  Description = c(
    "PI3K-Akt signaling pathway",
    "MAPK signaling pathway",
    "NF-kappa B signaling pathway",
    "JAK-STAT signaling pathway",
    "Toll-like receptor signaling pathway"
  ),
  Count = c(175, 160, 145, 130, 155),
  color = c(
    "#1f77b4",
    "#ff7f0e",
    "#2ca02c",
    "#d62728",
    "#9467bd"
  ),
  stringsAsFactors = FALSE
)

# Combine all filtered data frames into a list
data_list <- list(
  BP = filtered_data_BP,
  CC = filtered_data_CC,
  MF = filtered_data_MF,
  DO = filtered_data_DO,
  Reactome = filtered_data_Reactome,
  KEGG = filtered_data_kegg
)

# Create the Circular Bar Chart
combined_and_visualized_data <- enrich_circo_bar(data_list)

}
