% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Consistency.R
\name{ExpectedLength}
\alias{ExpectedLength}
\title{Expected length}
\usage{
ExpectedLength(dataset, tree, nRelabel = 1000, compress = FALSE)
}
\arguments{
\item{dataset}{A phylogenetic data matrix of \pkg{phangorn} class
\code{phyDat}, whose names correspond to the labels of any accompanying tree.
Perhaps load into R using \code{\link[TreeTools]{ReadAsPhyDat}}.
Additive (ordered) characters can be handled using
\code{\link[TreeTools]{Decompose}}.}

\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{nRelabel}{Integer specifying how many times to relabel leaves when
estimating null tree length for \acronym{RHI} calculation.
\insertCite{Steell2023;textual}{TreeSearch} recommend 1000, but suggest that
100 may suffice.
If zero (the default), the \acronym{RHI} is not calculated.}

\item{compress}{Logical specifying whether to retain the compression of a
\code{phyDat} object or to return a vector specifying to each individual
character, decompressed using the dataset's \code{index} attribute.}
}
\value{
\code{ExpectedLength()} returns a numeric vector stating the median
length of each character in \code{dataset} on \code{tree} after \code{nRelabel} random
relabelling of leaves.
}
\description{
For a given dataset and tree topology, \code{ExpectedLength()} estimates the
length expected if the states of each character are shuffled randomly
across the leaves.
}
\references{
\insertAllCited{}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
