% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biophysmodel_Sceloporus.R
\name{Tb_lizard}
\alias{Tb_lizard}
\title{Operative Environmental Temperature of a Lizard}
\usage{
Tb_lizard(
  T_a,
  T_g,
  u,
  svl,
  m,
  psi,
  rho_s,
  elev,
  doy,
  sun = TRUE,
  surface = TRUE,
  a_s = 0.9,
  a_l = 0.965,
  epsilon_s = 0.965,
  F_d = 0.8,
  F_r = 0.5,
  F_a = 0.5,
  F_g = 0.5
)
}
\arguments{
\item{T_a}{\code{numeric} air temperature (C).}

\item{T_g}{\code{numeric} surface temperature (C).}

\item{u}{\code{numeric} wind speed (\ifelse{html}{\out{m s<sup>-1</sup>}}{\eqn{m s^-1}{ASCII}}).}

\item{svl}{\code{numeric} lizard snout vent length (mm).}

\item{m}{\code{numeric} lizard mass (g); note that it can be estimated as in \code{\link{mass_from_length}}: \ifelse{html}{\out{3.55 x 10<sup>-5</sup> x length<sup>3</sup>}}{\eqn{3.55*10^-5 * length^3}{ASCII}}}

\item{psi}{\code{numeric} solar zenith angle (degrees).}

\item{rho_s}{\code{numeric} surface albedo (proportion). ~ 0.25 for grass, ~ 0.1 for dark soil, > 0.75 for fresh snow \insertCite{Campbell1998}{TrenchR}.}

\item{elev}{\code{numeric} elevation (m).}

\item{doy}{\code{numeric} day of year (1-366).}

\item{sun}{\code{logical} indicates whether lizard is in sun (\code{TRUE}) or shade (\code{FALSE}).}

\item{surface}{\code{logical} indicates whether lizard is on ground surface (\code{TRUE}) or above the surface (\code{FALSE}, e.g. in a tree).}

\item{a_s}{\code{numeric} lizard solar absorptivity (proportion), \code{a_s = 0.9} \insertCite{Gates1980}{TrenchR} (Table 11.4).}

\item{a_l}{\code{numeric} lizard thermal absorptivity (proportion), \code{a_l = 0.965} \insertCite{Bartlett1967}{TrenchR}.}

\item{epsilon_s}{\code{numeric} surface emissivity of lizards (proportion), \code{epsilon_s = 0.965} \insertCite{Bartlett1967}{TrenchR}.}

\item{F_d}{\code{numeric} the view factor between the surface of the lizard and diffuse solar radiation (proportion). i.e., the portion of the lizard surface that is exposed to diffuse solar radiation \insertCite{Bartlett1967}{TrenchR}.}

\item{F_r}{\code{numeric} the view factor between the surface of the lizard and reflected solar radiation (proportion).}

\item{F_a}{\code{numeric} the view factor between the surface of the lizard and atmospheric radiation (proportion).}

\item{F_g}{\code{numeric} the view factor between the surface of the lizard and ground thermal radiation (proportion).}
}
\value{
T_e \code{numeric} predicted body (operative environmental) temperature (C).
}
\description{
The function estimates body temperature (C, operative environmental temperature) of a lizard based on \insertCite{Campbell1998;textual}{TrenchR}. The function was designed for Sceloporus lizards and described in \insertCite{Buckley2008;textual}{TrenchR}.
}
\details{
The proportion of radiation that is direct is determined following \insertCite{Sears2011;textual}{TrenchR}.
  \cr \cr 
  Boundary conductance uses a factor of 1.4 to account for increased convection \insertCite{Mitchell1976}{TrenchR}.
}
\examples{
  Tb_lizard(T_a       = 25, 
            T_g       = 30, 
            u         = 0.1, 
            svl       = 60, 
            m         = 10, 
            psi       = 34, 
            rho_s     = 0.24, 
            elev      = 500, 
            doy       = 200, 
            sun       = TRUE, 
            surface   = TRUE, 
            a_s   = 0.9, 
            a_l   = 0.965, 
            epsilon_s = 0.965, 
            F_d       = 0.8, 
            F_r       = 0.5, 
            F_a       = 0.5, 
            F_g       = 0.5)

}
\references{
\insertAllCited{}
}
\seealso{
Other biophysical models: 
\code{\link{Grashof_number_Gates}()},
\code{\link{Grashof_number}()},
\code{\link{Nusselt_from_Grashof}()},
\code{\link{Nusselt_from_Reynolds}()},
\code{\link{Nusselt_number}()},
\code{\link{Prandtl_number}()},
\code{\link{Qconduction_animal}()},
\code{\link{Qconduction_substrate}()},
\code{\link{Qconvection}()},
\code{\link{Qemitted_thermal_radiation}()},
\code{\link{Qevaporation}()},
\code{\link{Qmetabolism_from_mass_temp}()},
\code{\link{Qmetabolism_from_mass}()},
\code{\link{Qnet_Gates}()},
\code{\link{Qradiation_absorbed}()},
\code{\link{Qthermal_radiation_absorbed}()},
\code{\link{Reynolds_number}()},
\code{\link{T_sky}()},
\code{\link{Tb_CampbellNorman}()},
\code{\link{Tb_Gates2}()},
\code{\link{Tb_Gates}()},
\code{\link{Tb_butterfly}()},
\code{\link{Tb_grasshopper}()},
\code{\link{Tb_limpetBH}()},
\code{\link{Tb_limpet}()},
\code{\link{Tb_lizard_Fei}()},
\code{\link{Tb_mussel}()},
\code{\link{Tb_salamander_humid}()},
\code{\link{Tb_snail}()},
\code{\link{Tbed_mussel}()},
\code{\link{Tsoil}()},
\code{\link{actual_vapor_pressure}()},
\code{\link{boundary_layer_resistance}()},
\code{\link{external_resistance_to_water_vapor_transfer}()},
\code{\link{free_or_forced_convection}()},
\code{\link{heat_transfer_coefficient_approximation}()},
\code{\link{heat_transfer_coefficient_simple}()},
\code{\link{heat_transfer_coefficient}()},
\code{\link{saturation_vapor_pressure}()},
\code{\link{saturation_water_vapor_pressure}()}
}
\concept{biophysical models}
