% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvTqmc.R
\name{mvTqmc}
\alias{mvTqmc}
\title{Truncated multivariate student cumulative distribution (QMC version)}
\usage{
mvTqmc(l, u, Sig, df, n = 1e+05)
}
\arguments{
\item{l}{lower bound for truncation (infinite values allowed)}

\item{u}{upper bound for truncation}

\item{Sig}{covariance matrix}

\item{df}{degrees of freedom}

\item{n}{sample size}
}
\value{
a list with components
\itemize{
\item \code{prob}: estimated value of probability Pr\eqn{(l<X<u)}
\item \code{relErr}: estimated relative error of estimator
\item \code{upbnd}: theoretical upper bound on true Pr\eqn{(l<X<u)}
}
}
\description{
Computes an estimator of the probability Pr\eqn{(l<X<u)},
where \code{X} is a zero-mean multivariate student vector
with scale matrix \code{Sig} and degrees of freedom \code{df}.
Infinite values for vectors \code{u} and \code{l} are accepted.
}
\details{
This version uses a Quasi Monte Carlo (QMC) pointset
of size \code{ceiling(n/12)} and estimates the relative error
using 12 independent randomized QMC estimators; QMC
is slower than ordinary Monte Carlo (see \code{\link{mvTcdf}}),
but is also likely to be more accurate when \eqn{d<50}.
}
\note{
If you want to estimate Pr\eqn{(l<Y<u)},
where \eqn{Y} follows a Student distribution with \code{df} degrees of freedom,
location vector \code{m} and scale matrix \code{Sig},
then use \code{mvTqmc(Sig, l - m, u - m, nu, n)}.
}
\examples{
d <- 25; nu <- 30;
l <- rep(1, d) * 5; u <- rep(Inf, d);
Sig <- 0.5 * matrix(1, d, d) + 0.5 * diag(d);
est <- mvTqmc(l, u, Sig, nu, n = 1e4)
\dontrun{
d <- 5
Sig <- solve(0.5*diag(d)+matrix(0.5, d,d))
## mvtnorm::pmvt(lower = rep(-1,d), upper = rep(Inf, d), df = 10, sigma = Sig)[1]
mvTqmc(rep(-1, d), u = rep(Inf, d), Sig = Sig, df = 10, n=1e4)$prob
}
}
\references{
Z. I. Botev (2017), \emph{The Normal Law Under Linear Restrictions:
Simulation and Estimation via Minimax Tilting}, Journal of the Royal
Statistical Society, Series B, \bold{79} (1), pp. 1--24

Z. I. Botev and P. L'Ecuyer (2015), Efficient probability estimation
and simulation of the truncated multivariate Student-t distribution,
Proceedings of the 2015 Winter Simulation Conference, pp. 380-391
}
\seealso{
\code{\link{mvTcdf}}, \code{\link{mvrandt}}, \code{\link{mvNqmc}}, \code{\link{mvrandn}}
}
\author{
\code{Matlab} code by Zdravko I. Botev, \code{R} port by Leo Belzile
}
\keyword{internal}
