% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hibbing_input_validation.R
\name{hibbing-input-validation}
\alias{hibbing-input-validation}
\alias{TwoRegression_Hibbing18_variable_validate}
\alias{TwoRegression_Hibbing18_algorithm_validate}
\title{Internal functions for the 2RM wrapper}
\usage{
TwoRegression_Hibbing18_variable_validate(
  varname,
  AG,
  algorithm,
  sensor = c("accelerometer", "gyroscope", "magnetometer")
)

TwoRegression_Hibbing18_algorithm_validate(algorithm)
}
\arguments{
\item{varname}{character scalar. Name of variable to check}

\item{AG}{data frame of ActiGraph data}

\item{algorithm}{An integer/numeric scalar or vector giving the algorithm(s)
to apply to the data from the primary accelerometer and (if applicable)
IMU. Must be \code{1} (accelerometer only), \code{2} (accelerometer and
gyroscope), \code{3} (accelerometer, gyroscope, and magnetometer), or any
combination thereof}

\item{sensor}{character scalar indicating if \code{varname} corresponds to an
accelerometer variable or gyroscope variable}
}
\description{
Internal functions for the 2RM wrapper
}
\keyword{internal}
