% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_regression.R
\name{multivariate_linear_regression}
\alias{multivariate_linear_regression}
\title{Multivariate Linear Regression}
\usage{
multivariate_linear_regression(data, learn = FALSE, waiting = TRUE)
}
\arguments{
\item{data}{x*y data frame with already classified observations. Each column
represents a parameter of the values (independent variable). The last column
represents the classification value (dependent variable). Each row is a different observation.}

\item{learn}{Boolean value. If it is set to "TRUE" multiple clarifications
and explanations are printed along the code}

\item{waiting}{If TRUE while \code{learn} = TRUE. The code will stop in each
"block" of code and wait for the user to press "enter" to continue.}
}
\value{
List containing a list for each independent variable,
 each one contains, the variable name, the intercept and the slope.
}
\description{
Calculates and plots the linear regression of a given set of values.
Being all of them independent values but one, which is the dependent value.
It provides information about the process and intermediate values used to calculate the line equation.
}
\examples{
# example code
multivariate_linear_regression(db1rl)

}
\author{
Víctor Amador Padilla, \email{victor.amador@edu.uah.es}
}
