% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printUBaymodel.R
\name{print.UBaymodel}
\alias{print.UBaymodel}
\alias{printResults}
\alias{summary.UBaymodel}
\alias{plot.UBaymodel}
\title{Print a UBayFS model}
\usage{
\method{print}{UBaymodel}(x, ...)

printResults(model)

\method{summary}{UBaymodel}(object, ...)

\method{plot}{UBaymodel}(x, ...)
}
\arguments{
\item{x}{a `UBaymodel` object created using \link{build.UBaymodel}}

\item{...}{additional print parameters}

\item{model}{a `UBaymodel` object created using \link{build.UBaymodel} after training}

\item{object}{a `UBaymodel` object created using \link{build.UBaymodel}}
}
\value{
prints model summary to the console, no return value
}
\description{
Print details of a `UBaymodel`
}
\section{Functions}{
\itemize{
\item \code{printResults()}: Display and summarize the results of UBayFS after feature selection.

\item \code{summary(UBaymodel)}: A summary of a `UBaymodel`

\item \code{plot(UBaymodel)}: A barplot of a `UBaymodel` containing prior weights, ensemble counts and the selected features.

}}
