% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{LowFlows}
\alias{LowFlows}
\title{Low Flows}
\usage{
LowFlows(CDs = NULL, AREA = NULL, SAAR = NULL, BFIHOST = NULL, Exclude = NULL)
}
\arguments{
\item{CDs}{Catchment descriptors derived from the GetCDs or CDsXML function.}

\item{AREA}{Catchment area (km2) - for when CDs is not applied}

\item{SAAR}{Average annual rainfall (mm) - for when CDs is not applied}

\item{BFIHOST}{An estimate of baseflow index - for when CDs is not applied}

\item{Exclude}{A site reference. This is to exclude sites that you do not want used in the estimate. For example, if you're seeing how the function performs on a gauged site, you may want to exclude it from the analysis.}
}
\value{
A data.frame with one column of flow estimates. The row names denote the name of each estimate.
}
\description{
A function to estimate lower flow quantiles in ungauged catchments.
}
\details{
This function provides estimates of the mean flow, Q95, Q70, Q50, Q10, and Q5.
The function works by finding the 30 catchments in the NRFA data set with the most similar SAAR9120 to the subject site (via the API).
The observed flows for those catchments are scaled by the catchment area. Then a weighted average is taken and multiplied by the subject site catchment area for the final estimate.
The weighting is done by Eucidean distance based on SAAR9120 and BFIHOST19scaled. These are weighted based on the correlation of these descriptors to the scaled flows.
}
\examples{
# Get some catchment descriptors, then estimate the flows
\dontrun{
CDs_27083 <- GetCDs(27083)
LowFlows(CDs_27083)
}
# Now estimate again but remove gauge 27083 from the analysis
\dontrun{
LowFlows(CDs_27083, Exclude = 27083)
}
}
\author{
Anthony Hammond
}
