% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJheatmap.R
\name{VDJheatmap}
\alias{VDJheatmap}
\title{Calculates the distance between VDJ germlines of interest and produces a matrix that can be used for further analysis or viewed using Heatmap/pheatmap/ComplexHeatmap.}
\usage{
VDJheatmap(species, chain, source, inference.method)
}
\arguments{
\item{species}{Specifies desired species. Current species options can be found by running unique(VDJgermlines$species) after loading in data(VDJgermlines). "all_species" will select all available species. Species include ("alpaca","bovine","crab_eating_macaque","dog",
"human","mouse","pig","platypus","rabbit",raintrout","rat","rhesus monkey","salmon",
"sheep","zebrafish","atlanticcod","catfish","teleostei","goat","dolphin","mamonkey",
"camel","runny")}

\item{chain}{Specifies the desired chain. "all_chains" will select all chains. The various chains can be listed by running unique(VDJgermlines$chain).Antibody loci start with IG, TCR starts with TR.NExt comes either heavy, light, alpha, beta etc. Examples include IGHD IGHJ IGHV IGIJ IGIV IGKJ IGKV IGLJ IGLV TRAJ TRAV TRBD TRBJ TRBV TRDD TRDJ TRDV TRGJ TRGV}

\item{source}{Specifies from which source the desired chains should be taken from.  Current sources can be found by running unique(VDJgermlines$source) after loading in data(VDJgermlines). IMGT and vgenerepertoire are currently present.}

\item{inference.method}{Specifies the distance metric to be used to calculate distance. Currently includes parameters from stringdist::stringdistmatrix(), such as "lv","jv","hamming","qgram","cosine","Jaccard","lcs", or "soundex".}
}
\value{
Returns a matrix where the entries correspond to the VDJ germlines used the neighbor joining algorithm. Can be viewed by heatmap() in base r, or pheatmap::pheatmap(VDJheatmap).
}
\description{
Calculates the distance between VDJ germlines of interest and produces a matrix that can be used for further analysis or viewed using Heatmap/pheatmap/ComplexHeatmap.
}
\examples{
VDJheatmap(species = "dog",chain = "IGHD",source = "IMGT")
}

