% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDSM_heatmap.R
\name{VDSM_heatmap}
\alias{VDSM_heatmap}
\title{VDSM-heatmap.}
\usage{
VDSM_heatmap(
  X,
  f,
  p,
  Anchor.estimate,
  xlim = NULL,
  ylim = NULL,
  Anchor.model = NULL,
  fontsize = NULL
)
}
\arguments{
\item{X}{A m*p matrix which contains m different p-dimensional models. All the elements are either 0 or 1.}

\item{f}{A vector with m elements which represent each model's frequency in X.}

\item{p}{The number of variate in the model.}

\item{Anchor.estimate}{An estimation for the anchor model.}

\item{xlim}{A vector with two elements which determine the range of x-axis in the plot.}

\item{ylim}{A vector with two elements which determine the range of y-axis in the plot.}

\item{Anchor.model}{A vector containing p elements with either 1 or 0 value and must be found in X. Default is the model with the highest frequency.}

\item{fontsize}{Customize the size of the font in the circles, default is 1.5.}
}
\value{
A list with components
\item{Heatmap.info}{The table includes all the information about each group, i.e., the total possible number of models in the group and the actual existing number of model in the group.}
\item{Hplus.histogram}{The frequency of Hamming distance plus.}
\item{Hminus.weighted.histogram}{The frequency of Hamming distance minus-weighted.}
}
\description{
Plotting the VDSM-heatmap.
}
\examples{
data(exampleX)
X=exampleX
data(examplef)
f=examplef
p=8
Anchor.estimate=c(3,2.5,2,1.5,1,0,0,0)
Heatmap_example1 = VDSM_heatmap(X,f,p,Anchor.estimate)
Heatmap_example2 = VDSM_heatmap(X,f,p,Anchor.estimate,fontsize=3)
Heatmap_example3 = VDSM_heatmap(X,f,p,Anchor.estimate,xlim=c(0,5),ylim=c(0,5),fontsize=3)
}
