% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/vardif.R
\name{vardif}
\alias{vardif}
\title{Estimate Residual Variance with Differene-Based Method.}
\usage{
vardif(x, y, type, r, m)
}
\arguments{
\item{x}{numeric Equally spaced design points.}

\item{y}{numeric Responses}

\item{type}{character Taking "opt" or "ord", default as "ord"}

\item{r}{numeric The order of employed difference sequence.}

\item{m}{numeric The bandwidth or the number of regressors.}
}
\value{
\item{u}{numeric The estimated variance.}
}
\references{
Tong, T. and Wang, Y. (2005). Estimating residual variance in nonparametric regression using least squares, Biometrika 92: 821 - 830.

Wenlin Dai, Tiejun Tong and Lixing Zhu (2017) Optimal sequence or ordinary sequence? A unified framework for variance estimation in nonparametric regression, Statistical Science.
}
\description{
Estimate residual variance with differene-based method.
}
\examples{
x<-1:100/100
y<-5*sin(2*pi*x)+rnorm(100)*0.5
type="ord"
r<-2
m<-10
vardif(x,y,type,r,m)
}

