% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vhRunsTable.R
\name{VhgRunsTable}
\alias{VhgRunsTable}
\title{VhgRunsTable: Generate a gt summary table of unique runs for each virus group}
\usage{
VhgRunsTable(
  vh_file,
  groupby = "best_query",
  taxa_rank = "Family",
  cut = 1e-05,
  title = "Summary of unique runs by virus group",
  title_align = "left",
  names_ = NULL,
  align = "left",
  subtitle = NULL,
  data_row.pad = 6,
  column_colour = "dodgerblue4",
  title_size = 26,
  subtitle_size = 14,
  title_weight = "bold",
  title_colour = "dodgerblue4",
  table_font_size = 14,
  cell_colour = "grey90",
  col_everyrow = FALSE
)
}
\arguments{
\item{vh_file}{A data frame containing the Virushunter hittables results.}

\item{groupby}{(optional): A character specifying the column containing the groups (default: "best_query").
Note: Gatherer hittables do not have a "best_query" column. Please provide an appropriate column for grouping.}

\item{taxa_rank}{(optional): When \code{groupby} is set to "ViralRefSeq_taxonomy", specify the taxonomic rank to group your data by.
Supported ranks are:
\itemize{
\item "Subphylum"
\item "Class"
\item "Subclass"
\item "Order"
\item "Suborder"
\item "Family" (default)
\item "Subfamily"
\item "Genus" (including Subgenus)
}}

\item{cut}{(optional): A numeric value representing the cutoff for the refseq E-value (default: 1e-5).
Removes rows in file with values larger than cutoff value in "ViralRefSeq_E" column.}

\item{title}{(optional): The title of the plot (default: "Summary of unique runs by virus group").}

\item{title_align}{(optional): A character vector specifying the alignment of title (and subtitle) text.
Possible values are "left" (default), "center", or "right".}

\item{names_}{(optional): A vector of length 3 containing column names (default: c("Virus Group","Number of Unique SRA Runs","SRAs Found")).}

\item{align}{(optional): A character vector specifying the alignment of text in the table columns.
Possible values are "left" (default), "center", or "right".}

\item{subtitle}{(optional): A character specifying the subtitle of the plot (default: NULL).}

\item{data_row.pad}{(optional): Numeric value specifying the row padding (default: 6).}

\item{column_colour}{(optional): character specifying the background colour for the column header (default: "dodgerblue4").}

\item{title_size}{(optional): The size of the title text (default: 26).}

\item{subtitle_size}{(optional): Numeric specifying the size of the subtitle text (default: 14).}

\item{title_weight}{(optional): Character or numeric value specifying title font weight.
The weight of the font can be modified thorough a text-based option such as "normal", "bold" (default),
"lighter", "bolder", or, a numeric value between 1 and 1000, inclusive.}

\item{title_colour}{(optional): A character specifying the color for the title text (default: "dodgerblue4").}

\item{table_font_size}{(optional): Numeric value specifying table font size. This will change font
size for the column header and for all values in each cell (default: 14).}

\item{cell_colour}{(optional): Character specifying cell colour (default: "grey90").}

\item{col_everyrow}{(optional): Bool value specifying if every row or every second row of the table
should be filled with the colour from the cell_colour argument. col_everyrow = TRUE colors every
row and col_everyrow = FALSE (default) colors every second row.}
}
\value{
A formatted gt table summarizing unique runs for each virus group
}
\description{
VhgRunsTable generates a summary table of unique runs for each virus group
based on the input data set.
}
\details{
VhgRunsTable calculates the number of unique runs for each virus group from the input data set.
It takes VirusHunter hittables as input and determines how many runs (SRA runs or local FASTQ files) found a specific virus family.

A graphical table is returned with two columns. The first column contains the name of the virus group,
while the second column contains all IDs of SRA runs or local files that found that virus group.
}
\examples{
path <- system.file("extdata", "virushunter.tsv", package = "Virusparies")
vh_file <- ImportVirusTable(path)

# example 1: generate table with defaul arguments
table <- VhgRunsTable(vh_file,cut = 1e-5)

table

# example 2: generate table with custom arguments

table_2 <- VhgRunsTable(vh_file,title = "test",title_align="right",
names_ = c("column_1","column_2","column_3"),align = "right",subtitle="subtitlele")

table_2

# example 3: virusgatherer example
# import gatherer files
path2 <- system.file("extdata", "virusgatherer.tsv", package = "Virusparies")
vg_file <- ImportVirusTable(path2)


table_3 <- VhgRunsTable(vg_file,groupby = "ViralRefSeq_taxonomy")

table_3

}
\seealso{
\code{\link{VhgRunsBarplot}}
}
