% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_substract.R, R/cluster_substract_V2.R
\name{distance_clustering}
\alias{distance_clustering}
\title{Clustering of non connected objects in a point cloud.}
\usage{
distance_clustering(data, d_clust, method, C_size, message)

distance_clustering(data, d_clust, method, C_size, message)
}
\arguments{
\item{data}{a data.frame or data.table containing the x, y, z, ... coordinates of a point cloud or voxel cloud.}

\item{d_clust}{numeric. The distance required to consider two points as being part of two different clusters. Default = 0.02.}

\item{method}{character. The algorithm to use for clustering. Can be either "D_mat" or "Iter", see details. Default = "D_mat".}

\item{C_size}{(optional) numeric. If \code{method = "Iter"}, sets the maximal size of a cluster (in distance unit).}

\item{message}{logical. If FALSE, messages are disabled. Default = TRUE.}
}
\value{
The input data with an additionnal field containing the cluster ID.

The input data with an additionnal field containing the cluster ID.
}
\description{
Clustering objects with non common points: two points located within a user defined distance from each other are considered
             as the parts of a unique object. This function is well suited to be applied to the outputs of the
             \link{substract_point_clouds} function.

Clustering objects with non common points: two points located within a user defined distance from each other are considered
             as the parts of a unique object. This function is well suited to be applied to the outputs of the
             \link{substract_point_clouds} function.
}
\details{
If \code{method == "D_mat"} the clustering process is based on building a matrix distance. This is time efficient but use a lot of memory.
         If \code{method == "Iter"} a slower but memory efficient iterative process is used. In some cases, D_clust can help to speed up the process.
}
\examples{
#- import datasets
t0=data.table::fread(system.file("extdata", "Tree_t0.asc", package="VoxR"))
t1=data.table::fread(system.file("extdata", "Tree_t1.asc", package="VoxR"))

#- keep only the tree crown
t0 = t0[z>=0,]
t1 = t1[z>=0,]

#- substract t0 to t1 with the hull method
diff = VoxR::substract_point_clouds(t0 = t0,t1 = t1, method = "hull")

#- clustering the difference between t0 and t1
clust = VoxR::distance_clustering(diff,d_clust = 0.03)

#- plot the result (NOTE that colors are redundant)
rgl::open3d()
rgl::plot3d(clust,col=clust$cluster,add=TRUE)
#- import datasets
t0=data.table::fread(system.file("extdata", "Tree_t0.asc", package="VoxR"))
t1=data.table::fread(system.file("extdata", "Tree_t1.asc", package="VoxR"))

#- keep only the tree crown
t0 = t0[z>=0,]
t1 = t1[z>=0,]

#- substract t0 to t1 with the hull method
diff = VoxR::substract_point_clouds(t0 = t0,t1 = t1, method = "hull")

#- clustering the difference between t0 and t1 with the matrix distance based method
clust = VoxR::distance_clustering(diff,d_clust = 0.03)

#- plot the result (NOTE that colors are redundant)
rgl::open3d()
rgl::plot3d(clust,col=clust$cluster,add=TRUE)
\donttest{
#- clustering the difference between t0 and t1 with the iterative method
clust = VoxR::distance_clustering(diff,d_clust = 0.03,method = "Iter")

#- plot the result (NOTE that colors are redundant)
rgl::open3d()
rgl::plot3d(clust,col=clust$cluster,add=TRUE)

#- clustering the difference between t0 and t1 with the iterative method with maximum object size
clust = VoxR::distance_clustering(diff,d_clust = 0.03,method = "Iter",C_size = 1)

#- plot the result (NOTE that colors are redundant)
rgl::open3d()
rgl::plot3d(clust,col=clust$cluster,add=TRUE)
}
}
\references{
Lecigne, B., Delagrange, S., & Messier, C. (2018). Exploring trees in three dimensions: VoxR, a novel voxel-based R package dedicated to
            analysing the complex arrangement of tree crowns. Annals of botany, 121(4), 589-601.
}
