% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exp_Map.R
\name{Exp_Map_Barycenter_Method}
\alias{Exp_Map_Barycenter_Method}
\title{Numerical implementation of the Exponential map}
\usage{
Exp_Map_Barycenter_Method(density.grid, forecast, cdf)
}
\arguments{
\item{density.grid}{The values where the cdf \eqn{\hat{F}} is evaluated}

\item{forecast}{A vector that contains the WAR(p) model forecast result}

\item{cdf}{The quantile grid used in forecasting}
}
\value{
A numeric vector that contains \eqn{\hat{F}_t(u)} evaluated over \code{density.grid}
}
\description{
This function implements the Exponential map to calculate \eqn{\hat{F}_t(u)} for all \eqn{u} in the cdf/pdf support
}
\references{
\cite{Wasserstein Autoregressive Models for Density Time Series, Chao Zhang, Piotr Kokoszka, Alexander Petersen, 2022}
}
\keyword{internal}
