% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warPred.R
\name{predict.WARp}
\alias{predict.WARp}
\title{Prediction by WAR(p) models}
\usage{
\method{predict}{WARp}(object, dSup, expSup, ...)
}
\arguments{
\item{object}{A WARp object, the output of \code{WARp()}.}

\item{dSup}{Optional, a numeric vector, the grid over which forecasted cdf/pdf is evaluated. Should be supplied/ignored with \code{expSup} together.}

\item{expSup}{Optional, a numeric vector, the grid over the Exponential map is applied, \code{dSup} should cover and be denser than \code{expSup}.   Should be supplied/ignored with \code{dSup} together.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A list of:
\item{pred.cdf}{predicted cdf}
\item{pred.pdf}{predicted pdf}
\item{dSup}{support of the predicted cdf/pdf}
}
\description{
a method of the WARp class which produces a one-step ahead prediction by WAR(p) models
}
\references{
\cite{Wasserstein Autoregressive Models for Density Time Series, Chao Zhang, Piotr Kokoszka, Alexander Petersen, 2022}
}
\seealso{
\code{\link{WARp}}
}
