% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pwreg}
\alias{pwreg}
\title{Fit a standard proportional win-fractions (PW) regression model}
\usage{
pwreg(
  ID,
  time,
  status,
  Z,
  rho = 0,
  strata = NULL,
  fixedL = TRUE,
  eps = 1e-04,
  maxiter = 50
)
}
\arguments{
\item{ID}{a vector of unique subject-level identifiers.}

\item{time}{a vector of event times.}

\item{status}{a vector of event type labels. 0: censoring, 1:death
and 2: non-fatal event.}

\item{Z}{a matrix or a vector of covariates.}

\item{rho}{a non-negative number as the power of the survival function used
in the weight. Default (\code{rho=0}) is recommended. If there is a `strata` argument,
then `rho` is ignored.}

\item{strata}{a vector of stratifying variable if a stratified model is desired.}

\item{fixedL}{logical variable indicating which variance estimator to be used. If `TRUE`,
the type I variance estimator (for a small number strata) is used; otherwise
the type II variance estimator (for a large number strata) is used.}

\item{eps}{precision for the convergence of Newton-Raphson algorithm.}

\item{maxiter}{maximum number of iterations allow for the Newton-Raphson
algorithm.}
}
\value{
An object of class \code{pwreg} with the following components.
\code{beta}:a vector of estimated regression coefficients. \code{Var}:estimated
covariance matrix for \code{beta}. \code{conv:} boolean variable indicating
whether the algorithm converged within the maximum number of iterations.
}
\description{
Fit a standard proportional win-fractions (PW) regression model.
}
\examples{
library(WR)
head(non_ischemic)
id_unique <-unique(non_ischemic$ID)

# Randomly sample 200 subjects from non_ischemic data
set.seed(2019)
id_sample <- sample(id_unique, 200)
non_ischemic_reduce <- non_ischemic[non_ischemic$ID \%in\% id_sample, ]

# Use the reduced non_ischemic data for analysis
nr <- nrow(non_ischemic_reduce)
p <- ncol(non_ischemic_reduce)-3
ID <- non_ischemic_reduce[,"ID"]
time <- non_ischemic_reduce[,"time"]
status <- non_ischemic_reduce[,"status"]
Z <- as.matrix(non_ischemic_reduce[,4:(3+p)],nr,p)
## unstratified analysis
pwreg.obj <- pwreg(time=time,status=status,Z=Z,ID=ID)
print(pwreg.obj)
\dontrun{
## stratified PW by sex
sex<-Z[,3]
## take out sex from the covariate matrix
Z1<-Z[,-3]
pwreg.obj1 <- pwreg(time=time,status=status,Z=Z1,ID=ID,strata=sex)
print(pwreg.obj1)
}
}
\references{
Mao, L. and Wang, T. (2020). A class of proportional win-fractions
regression models for composite outcomes. Biometrics, 10.1111/biom.13382

Wang, T. and Mao, L. (2021+). Stratified Proportional Win-fractions
Regression Analysis.
}
\seealso{
\code{\link{score.proc}}, \code{\link{print.pwreg}}
}
\keyword{pwreg}
