% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wide2long.R
\name{wide2long}
\alias{wide2long}
\title{Reshapes the data}
\usage{
wide2long(data, ID = "ID", separator = "_", hemisphere = "prefix", start, end)
}
\arguments{
\item{data}{The wide format data.}

\item{ID}{The column of identifiers.}

\item{separator}{A character vector that separates characters in the variable names.}

\item{hemisphere}{Whether a hemisphere indicator in the variable names is a prefix or suffix. At this point, only the "prefix" option is available.}

\item{start}{The column that specifies the starting point of a set of variables to be reshaped}

\item{end}{The column that specifies the endpoint of a set of variables to be reshaped}
}
\value{
The long format data
}
\description{
wide2long() function is data-reshaping function for wide format data.
This function mainly targets the brain structure data that contains the data from the left and right hemispheres
}
\examples{

data(sample_data)

long<-wide2long(
data=sample_data,
ID="ID",
separator="_",
start="lh_Thalamus",
end="rh_AccumbensArea",
hemisphere="prefix"
)
}
