% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EST_ZINAR.R
\name{EST_ZINAR}
\alias{EST_ZINAR}
\title{Parameter Estimation for ZINAR(1) Models}
\usage{
EST_ZINAR(y,init = NULL,tol = 1e-05,iter = 1000,model,innovation,desc = FALSE)
}
\arguments{
\item{y}{A vector containing a discrete non-negative time series dataset.}

\item{init}{A vector containing the initial parameters estimates to maximize the likelihood function. If not informed, uses Yule-Walker method to calculate.}

\item{tol}{Tolerance for the convergence of the algorithm. Defaults to 1e-5.}

\item{iter}{Maximum number of iterations of the algorithm. Defaults to 1000.}

\item{model}{Must be "zinar", if the innovation have Zero-Inflated distribution, and "inar", otherwise.}

\item{innovation}{Must be "Po" if Poisson, "NB" if Negative binomial or "GI" if Gaussian inverse.}

\item{desc}{TRUE to plot the exploratory graphs. Defaults to FALSE.}
}
\value{
Returns a list containing the parameters estimates and the number of interactions.
}
\description{
This function uses the EM algorithm to find the maximum likelihood estimates of a ZINAR(1) model.
}
\examples{

# Estimates the parameters of an INAR(1) and a ZINAR(1) models with Poisson innovations
# for the monthly number of drug offenses recorded from January 1990 to December 2001
# in Pittsburgh census tract 2206.

data(PghTracts)

y=ts(PghTracts$DRUGS,start=c(1990,1),end=c(2001,12),frequency=12)

Inar1 = EST_ZINAR(y, init = c(0.3,0.5,2), model = "inar", innovation = "Po",desc = TRUE)

ZIPInar1 = EST_ZINAR(y, init = c(0.3,0.5,2), model = "zinar", innovation = "Po",desc = TRUE)

}
\references{
Aldo M.; Medina, Francyelle L.; Jales, Isaac C.; Bertail, Patrice. First-order integer valued AR processes with zero-inflated innovations. Cyclostationarity: Theory and Methods, Springer Verlag - 2021, v. 1, p. 19-40.
}
