% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasetPreProcessing.R
\name{datasetPreProcessing}
\alias{datasetPreProcessing}
\title{datasetPreProcessing}
\usage{
datasetPreProcessing(
  zpFileDir,
  zpSaveDir,
  minPixels = 5000,
  imageExtension = ".jpg",
  verbose = TRUE
)
}
\arguments{
\item{zpFileDir}{Directory of subdirectories containing zooplankton images}

\item{zpSaveDir}{Directory to setup the subdirectory structure for the extracted images}

\item{minPixels}{Integer specifying the minimum number of pixels allowed in an extracted image
See "batch_imagePreProcessing" for details [Default: 5000]}

\item{imageExtension}{String specifying the extension the images will have (must include ".")
[Default: ".jpg"]}

\item{verbose}{Boolean variable indicating whether the script should print info to console
[Default: TRUE]}
}
\description{
Preprocessing a directory structure of zooplankton images, and saving the resultant images
             to another directory structure
}
\examples{
\dontrun{
zpFileDir <- 'Users/$(whoami)/Images/ZooplanktonImages'
zpSaveDir <- 'Users/$(whoami)/Images/ExtractedImages'
batchPreProcessing(zpImgDir, zpSaveDir)
}
}
