% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aSPUsPath2.r
\name{aSPUsPath2}
\alias{aSPUsPath2}
\title{Pathway based Sum of Powered Score tests (SPUsPath) and adaptive SPUpath (aSPUsPath) test for single trait - pathway association with GWAS summary statistics. (vector version, fast when n is large)}
\usage{
aSPUsPath2(
  Zs,
  corSNP,
  pow = c(1, 2, 4, 8, Inf),
  pow2 = c(1, 2, 4, 8),
  snp.info,
  gene.info,
  n.perm = 1000,
  Ps = FALSE,
  prune = TRUE
)
}
\arguments{
\item{Zs}{Z-scores for each SNPs. It could be P-values if the Ps option is TRUE.}

\item{corSNP}{Correlation matirx of the SNPs to be tested; estimated from a
reference panel (based on the same set of the reference alleles as
used in calculating Z-scores).}

\item{pow}{SNP specific power(gamma values) used in SPUpath test.}

\item{pow2}{GENE specific power(gamma values) used in SPUpath test.}

\item{snp.info}{SNP information matrix, the 1st column is SNP id, 2nd column is chromosome #, 3rd column indicates SNP location.}

\item{gene.info}{GENE information matrix, The 1st column is GENE id, 2nd column is chromosome #, 3rd and 4th column indicate start and end positions of the gene.}

\item{n.perm}{number of permutations.}

\item{Ps}{TRUE if input is p-value, FALSE if input is Z-scores. The default is FALSE.}

\item{prune}{if it is TRUE, do pruing before the test using pruneSNP function.}
}
\value{
P-values for SPUMpath tests and aSPUMpath test.
}
\description{
It gives p-values of the SPUsPath tests and aSPUsPath test with GWAS summary statistics. Faster than aSPUsPath function when n is large (N > 10^4).
}
\examples{
data(kegg9)

# p-values of SPUpath and aSPUpath tests.
\dontrun{out.a <- aSPUsPath2(kegg9$nP, corSNP = kegg9$ldmatrix, pow=c(1:8, Inf),
                  pow2 = c(1,2,4,8), 
                  snp.info=kegg9$snp.info, gene.info = kegg9$gene.info,
                  n.perm=1000, Ps = TRUE) }

#out.a

}
\references{
Il-Youp Kwak, Wei Pan (2015)
Adaptive Gene- and Pathway-Trait Association Testing with GWAS Summary Statistics,
Bioinformatics, 32(8):1178-1184
}
\seealso{
\code{\link{aSPUs}}
}
\author{
Il-Youp Kwak and Wei Pan
}
