% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{ShuttleDisaster}
\alias{ShuttleDisaster}
\title{Ambient Temperature and O-Ring Failures}
\format{A data frame with 23 observations on the following 2 variables.
\describe{ \item{temperature}{a numeric vector}
\item{failures}{a numeric vector} }}
\source{
Dalal, S.R., E.B. Fowlkes, and B. Hoadley. 1989. Risk analysis of
the Space Shuttle: Pre-Challenger prediction of failure. \emph{Journal of
the American Statistical Association} 408: 945-957.
}
\description{
Data on \code{temperature} and number of O-ring \code{failures} for 23 space
shuttle launches.
}
\examples{
str(ShuttleDisaster)
xyplot( jitter(failures, amount=0.1) ~ temperature, ShuttleDisaster,
  ylab='number of failures'
  )
}
\references{
Tufte, E.R. 1997. \emph{Visual Explanations: Images and
Quantities, Evidence and Narrative}. Graphics Press.

\url{http://www.edwardtufte.com/tufte/}
}
\keyword{datasets}

