% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{manhattan}
\alias{manhattan}
\alias{mean_character_difference}
\alias{modified_mean_character_difference}
\title{Manhattan and related distances}
\usage{
manhattan(x, y)

mean_character_difference(x, y)

modified_mean_character_difference(x, y)
}
\arguments{
\item{x, y}{Numeric vectors}
}
\value{
The distance between \code{x} and \code{y}. The modified mean
  character difference is undefined if all elements in \code{x} and \code{y}
  are zero, in which case we return \code{NaN}.
}
\description{
The Manhattan or city block distance is the sum of absolute differences
between the elements of two vectors. The \emph{mean character} difference
is a closely related measure.
}
\details{
For vectors \code{x} and \code{y}, the Manhattan distance is given by
\deqn{d(x, y) = \sum_i |x_i - y_i|.} Relation of \code{manhattan()} to
other definitions:
\itemize{
  \item Equivalent to R's built-in \code{dist()} function with
    \code{method = "manhattan"}.
  \item Equivalent to \code{vegdist()} with \code{method = "manhattan"}.
  \item Equivalent to the \code{cityblock()} function in
    \code{scipy.spatial.distance}.
  \item Equivalent to the \code{manhattan} calculator in Mothur.
  \item Equivalent to \eqn{D_7}{D_7} in Legendre & Legendre.
  \item Whittaker's index of association (\eqn{D_9}{D_9} in Legendre &
    Legendre) is the Manhattan distance computed after transforming to
    proportions and dividing by 2.
}

The mean character difference is the Manhattan distance divided by the
length of the vectors. It was proposed by Cain and Harrison in 1958.
Relation of \code{mean_character_difference()} to other definitions:
\itemize{
  \item Equivalent to \eqn{D_8} in Legendre & Legendre.
  \item For binary data, equivalent to \eqn{1 - S_1} in Legendre & Legendre,
    where \eqn{S_1} is the simple matching coefficient.
}

The modified mean character difference is the Manhattan distance divided by
the number elements where either \code{x} or \code{y} (or both) are nonzero.
Relation of \code{modified_mean_character_difference()} to other
definitions:
\itemize{
  \item Equivalent to \eqn{D_{19}} in Legendre & Legendre.
  \item Equivalent to \code{vegdist()} with \code{method = "altGower"}.
  \item For binary data, it is equivalent to the Jaccard distance.
}
}
\examples{
x <- c(15, 6, 4, 0, 3, 0)
y <- c(10, 2, 0, 1, 1, 0)
manhattan(x, y)
# Whittaker's index of association
manhattan(x / sum(x), y / sum(y)) / 2

mean_character_difference(x, y)
# Simple matching coefficient for presence/absence data
# Should be 2 / 6
mean_character_difference(x > 0, y > 0)

modified_mean_character_difference(x, y)
# Jaccard distance for presence/absence data
modified_mean_character_difference(x > 0, y > 0)
jaccard(x, y)
}
\references{
Cain AJ, Harrison GA. An analysis of the taxonomist's judgment of affinity.
Proceedings of the Zoological Society of London 1958;131:85-98.
}
