% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{mcintosh_d}
\alias{mcintosh_d}
\title{McIntosh dominance index D}
\usage{
mcintosh_d(x)
}
\arguments{
\item{x}{A numeric vector of species counts.}
}
\value{
The McIntosh dominance index, \eqn{0 \leq D < 1}. The index is undefined
  when the total number of counts is 1 or 0, in which case we return
  \code{NaN}.
}
\description{
McIntosh dominance index D
}
\details{
For a vector \code{x} of raw species counts, the McIntosh dominance index is
defined as \deqn{D = \frac{N - U}{N - \sqrt{N}},} where \eqn{N} is the total
number of counts and \eqn{U = \sqrt{\sum_i x_i^2}}.

This index is appropriate only for raw counts, not transformed counts or
proportions.

Equivalent to \code{mcintosh_d()} in \code{skbio.diversity.alpha}.
}
\examples{
x <- c(15, 6, 4, 0, 3, 0)
mcintosh_d(x)
}
\references{
McIntosh RP. An index of diversity and the relation of certain concepts to
diversity. Ecology. 1967;48:1115-1126.
}
