% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{mcintosh_e}
\alias{mcintosh_e}
\title{McIntosh's evenness measure E}
\usage{
mcintosh_e(x)
}
\arguments{
\item{x}{A numeric vector of species counts.}
}
\value{
McIntosh's evenness measure, \eqn{0 < E \leq 1}.  The index is
  undefined when the total number of counts is 0, in which case we return
  \code{NaN}.
}
\description{
McIntosh's evenness measure E
}
\details{
For a vector \code{x} of raw species counts, the McIntosh evenness measure
is \deqn{E = \frac{\sqrt{\sum_i x_i^2}}{\sqrt{(N - S + 1)^2 + S - 1},}}
where \eqn{N} is the total number of counts and \eqn{S} is the total
number of species observed.

This index is appropriate only for raw counts, not transformed counts or
proportions.

Equivalent to \code{mcintosh_e()} in \code{skbio.diversity.alpha}.
}
\examples{
x <- c(15, 6, 4, 0, 3, 0)
mcintosh_e(x)
}
\references{
Heip C, Engels P. Comparing Species Diversity and Evenness Indices. J. Mar.
Bioi. Ass. U.K. 1974;54:559-563.
}
