% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.abess.R
\name{predict.abess}
\alias{predict.abess}
\title{Make predictions from a fitted "\code{abess}" object.}
\usage{
\method{predict}{abess}(object, newx, type = c("link", "response"), support.size = NULL, ...)
}
\arguments{
\item{object}{An "\code{abess}" project.}

\item{newx}{New data used for prediction. If omitted, the fitted linear predictors are used.}

\item{type}{\code{type = "link"} gives the linear predictors for \code{"binomial"},
\code{"poisson"} or \code{"cox"} models; for \code{"gaussian"} models it gives the
fitted values. \code{type = "response"} gives the fitted probabilities for
\code{"binomial"} and \code{"ordinal"}, fitted mean for \code{"poisson"} and the fitted relative-risk for
\code{"cox"}; for \code{"gaussian"}, \code{type = "response"} is equivalent to \code{type = "link"}.}

\item{support.size}{An integer value specifies
the model size fitted at given \code{support.size}.
If \code{support.size = NULL}, then the model with
the best tuning value would be returned.
Default: \code{support.size = NULL}.}

\item{...}{Additional arguments affecting the predictions produced.}
}
\value{
The object returned depends on the types of family.
}
\description{
Make predictions from a fitted "\code{abess}" object.
}
\seealso{
\code{\link{print.abess}},
\code{\link{predict.abess}},
\code{\link{coef.abess}},
\code{\link{extract.abess}},
\code{\link{plot.abess}},
\code{\link{deviance.abess}}.
}
