% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{checkJumpDistance}
\alias{checkJumpDistance}
\title{Check if tags are jumping over arrays}
\usage{
checkJumpDistance(
  movements,
  tag,
  bio,
  detections,
  spatial,
  arrays,
  dotmat,
  paths,
  jump.warning,
  jump.error,
  GUI,
  save.tables.locally,
  n
)
}
\arguments{
\item{movements}{The movements table for a specific tag.}

\item{tag}{The tag being analysed.}

\item{bio}{A table with the tags and biometrics of the studied animals.}

\item{detections}{The detections data.frame for a specific tag.}

\item{spatial}{A list of spatial objects in the study area.}

\item{arrays}{a list containing information for each array.}

\item{dotmat}{The matrix of distances between arrays.}

\item{jump.warning}{If a tag crosses a number of arrays equal or greater
than \code{jump.warning} without being detected, a warning is issued. Defaults
to 2. To disable jump warnings, set to Inf. Must be equal to or lower than \code{jump.error}.}

\item{jump.error}{If a tag crosses a number of arrays equal or greater than
\code{jump.error} without being detected, user intervention is suggested.
Defaults to 3. To disable user intervention suggestions, set to Inf.}

\item{GUI}{One of "needed", "always" or "never". If "needed", a new window is
opened to inspect the movements only if the movements table is too big to be
displayed in R's console. If "always", a graphical interface is always created
when the possibility to invalidate events emerges. If "never", a graphical
interface is never invoked. In this case, if the table to be displayed does
not fit in R's console, a temporary file will be saved and the user will be
prompted to open and examine that file. Defaults to "needed".}

\item{save.tables.locally}{Logical: If a table must be temporarily stored into a file
for user inspection, should it be saved in the current working directory, or
in R's temporary folder?}

\item{n}{A string indicating the overall progress.}
}
\value{
A list of movements with updated 'Valid' columns
}
\description{
Check if tags are jumping over arrays
}
\keyword{internal}
