% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fromSource.R
\name{pushFromSource}
\alias{pushFromSource}
\title{Push a component into the Acumos repository from its source file}
\usage{
pushFromSource(
  url,
  file,
  name = "R Component",
  addSource = TRUE,
  token,
  create = TRUE,
  deploy = FALSE,
  license,
  headers,
  ...
)
}
\arguments{
\item{url}{URL for the POST request}

\item{file}{string, name of component source file (an R script)}

\item{name}{string, name of the component}

\item{addSource}{boolean, to add source file to the (ZIP) bundle or not}

\item{token}{token obtained from auth (optional)}

\item{create}{logical, \code{isCreateMicroservice} parameter. If TRUE the model Docker image 
is automatically created by the Acumos platform.  see Acumos onboarding documentation.
See Acumos onboarding documentation.}

\item{deploy}{logical. If TRUE the model is automatically deployed by the Acumos platform. 
This parameter cannot take the value TRUE, when the parameter \code{create} takes the value FALSE.
See Acumos onboarding documentation.}

\item{license}{optional string, name of a file to supply as the license. If not specified push()
will also try to locate a license.json file in the component bundle if present.}

\item{headers}{optional, named list or named character vector of HTTP headers that are to be added
to the request. NOTE: the meaning of optional headers depends on the onboarding server so consult
the documentation of the onboarding server for supported additional headers and their meaning.}

\item{...}{optional, named list or named character vector of HTTP headers that are to be added to 
the request. NOTE: the meaning of optional headers depends on the onboarding server so consult the
documentation of the onboarding server for supported additional headers and their meaning.}
}
\value{
invisibly, result of the request (may change in the future)
}
\description{
push pushes a component into the Acumos repository using the component source file (R file).
}
\note{
A regular component source file is an R script in which at least one of the three following
functions are defined: \code{acumos_predict}, \code{acumos_transform} or \code{acumos_fit}.
They respectively correspond to the functions \code{predict}, \code{transform} and \code{fit}
of \code{\link{compose}}. In that script, if the functions \code{acumos_generate}, \code{acumos_service}
or \code{acumos_initialize} are defined, they will also correspond to the other function
type arguments of \code{\link{compose}}, namely \code{generate}, \code{service} and \code{initialize}.

All the R objects defined in that script are included as auxiliary objects that are to be passed to
the global workspace of the component. They will fill the \code{aux} argument of \code{\link{compose}}.
}
\seealso{
\code{\link{push}}
}
