% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf.R
\name{sdf}
\alias{sdf}
\title{Smooth Discounted Flow}
\usage{
sdf(discharge, delta = 0.95)
}
\arguments{
\item{discharge}{vector of discharge data (numeric).}

\item{delta}{the discount factor which can be any value between (0,1),
defaults to 0.95. As \code{delta} approaches one, the average discounted
flow approaches mean flow. Small values of delta return values closer to
the current daily flow.}
}
\value{
vector of values the same length as \code{discharge}.
}
\description{
Applies exponential smoothing to discharge data.
}
\details{
The smooth discounted flow (SDF) was proposed by Kuhnert et al.
(2012). The premise of SDF is to incorporate the influence of historical
flows on flux:

\deqn{SDF(\delta) = d\kappa_{i-1} + (1-\delta)\hat{q}_{i-1},}

and

\deqn{\kappa_{i} = \sum_{m=1}^{i}\hat{q}_m,}
for discount factor \eqn{\delta}, where \eqn{\kappa_{i}} represents
cumulative flow up to the \eqn{i}th day.
}
\examples{
# Standard use case
ma <- sdf(lavaca$Flow, delta=0.95)
head(ma)


}
\references{
Kuhnert, Petra M., Brent L. Henderson, Stephen E. Lewis, Zoe T.
Bainbridge, Scott N. Wilkinson, and Jon E. Brodie. 2012. “Quantifying Total
Suspended Sediment Export from the Burdekin River Catchment Using the Loads
Regression Estimator Tool”
Water Resources Research 48 (4). \doi{10.1029/2011WR011080}.
}
