% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{analyze}
\alias{analyze}
\alias{analyze,data.frame-method}
\title{Analyze a dataset}
\usage{
analyze(
  data,
  statistics = list(),
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)

\S4method{analyze}{data.frame}(
  data,
  statistics = list(),
  data_distribution,
  use_full_twoarm_sampling_distribution = FALSE,
  design,
  sigma,
  exact = FALSE
)
}
\arguments{
\item{data}{a data.frame containing the data to be analyzed.}

\item{statistics}{a list of objects of class \code{\link{PointEstimator}},
\code{\link{ConfidenceInterval}} or
\code{\link{PValue}}.}

\item{data_distribution}{object of class \code{Normal} or \code{Student}.}

\item{use_full_twoarm_sampling_distribution}{logical indicating whether this estimator is intended to be used
with the full sampling distribution in a two-armed trial.}

\item{design}{object of class \code{TwoStageDesign}.}

\item{sigma}{assumed standard deviation.}

\item{exact}{logical indicating usage of exact n2 function.}
}
\value{
\code{Results} object containing the values of the statistics
when applied to data.
}
\description{
The \code{analyze} function can be used calculate the values of a list of
\link[adestr:PointEstimator]{point estimators},
\link[adestr:ConfidenceInterval]{confidence intervals},
and \link[adestr:PValue]{p-values} for a given dataset.
}
\details{
Note that in \code{\link{adestr}}, statistics are codes as functions of the
stage-wise sample means (and stage-wise sample variances if data_distribution is
\code{\link[adoptr]{Student}}). In a first-step, the data is summarized to produce these
parameters. Then, the list of statistics are evaluated at the values of these parameters.

The output of the \code{analyze} function also displays information on the hypothesis
test and the interim decision. If the \code{\link[adestr:Statistic-class]{statistics}} list is empty, this will
be the only information displayed.
}
\examples{
set.seed(123)
dat <- data.frame(
  endpoint = c(rnorm(28, 0.3)),
  stage = rep(1, 28)
)
analyze(data = dat,
        statistics = list(),
        data_distribution = Normal(FALSE),
        design = get_example_design(),
        sigma = 1)

# The results suggest recruiting 32 patients for the second stage
dat <- rbind(
  dat,
  data.frame(
    endpoint = rnorm(32, mean = 0.3),
    stage = rep(2, 32)))
analyze(data = dat,
        statistics = get_example_statistics(),
        data_distribution = Normal(FALSE),
        design = get_example_design(),
        sigma = 1)
}
