% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crrscKM.R
\name{crrscKM}
\alias{crrscKM}
\title{Stratified Proportional Subdistribution Hazards Model For Clustered Competing Risks Data With Covariate-Independent Censoring}
\usage{
crrscKM(
  times,
  causes,
  covariates,
  treatment = NULL,
  clusters = 1:length(times),
  cencode = 0,
  failcode = 1,
  stratified.model = TRUE,
  est.t = FALSE,
  pre.t = sort(times[causes == failcode]),
  Z0 = NULL
)
}
\arguments{
\item{times}{Failure/censored times.}

\item{causes}{Failure code for each failure type (1 or 2) and 0 for censoring.}

\item{covariates}{Matrix of covariates. Dummy variables must be created for categorical covariates.}

\item{treatment}{Treatment variable.}

\item{clusters}{Cluster variable. Independent data is assumed if this is not provided.}

\item{cencode}{Code for censoring. By default it is 0.}

\item{failcode}{Code for the failure type of interest. By default it is 1.}

\item{stratified.model}{\code{TRUE} or \code{FALSE}. By default, it is \code{TRUE} for stratified model. The stratification variable is \code{treatment}.
If this is \code{FALSE} and \code{est.t=TRUE}, then the \code{treatment} variable still needs to be provided and will be used as a covariate.}

\item{est.t}{\code{TRUE} or \code{FALSE}. By default this is \code{FALSE}. If it is \code{TRUE} then estimates of cumulative baseline hazard, adjusted cumulative incidence and predicted cumulative incidence are provided along with their standard errors at pre-specified time points.}

\item{pre.t}{Pre-specified time points.
By default these are all main event times.}

\item{Z0}{Covariate vector for prediction. By default this vector is a zero vector.}
}
\value{
Returns a list with the following components. If \code{est.t=FALSE} then only upto
$nstrata are provided.
\item{$coef}{Parameter estimates}
\item{$p.value}{p-value of regression coefficients}
\item{$var}{Covariance matrix of parameter estimates}
\item{$infor}{Information matrix}
\item{$loglikelihood}{Maximum log-likelihood value}
\item{$n}{Total number of observations used}
\item{$nevents}{Total number of events and censored observations}
\item{$nclusters}{Total number of clusters}
\item{$nstrata}{Total number of treatment groups}
\item{$CumBaseHaz.t}{Cumulative basline hazard estimates and their standard errors}
\item{$Fpredict.t}{Predicted cumulative incidence and their standard errors}
\item{$AdjustedF.t}{Adjusted cumulative incidence and their standard errors}
\item{$Adjusted.se.diff}{Standard error of the difference of adjusted cumulative incidence between the treatment groups}
}
\description{
Stratified proportional subdistribution hazards model for clustered competing risks data.
The survival probability of the censoring distribution is obtained using the Kaplan-Meier estimates.
The estimates of the cumulative baseline hazard along with their standard errors are provided at the
pre-specified time points.
Furthermore, the adjusted cumulative incidence rates along with their standard errors are calculated at pre-specified time points. The standard errors of the
the difference in adjusted cumulative incidence rates between the groups are also provided.
Finally, the estimated adjusted cumulative incidence rates given vector \code{Z0} along with their standard errors are provided at
pre-specified time points. Tied data are handled by adding a tiny random shift from a normal distribution with mean 0 and standard deviation
1e-09.
}
\examples{
#Simulated data
alpha = 0.5
d = simulate_CR_data(n=4,m=50,alpha=alpha,beta1=c(0.7,-0.7,-0.5)*1/alpha,
beta2=c(0.5,-0.5,1),betaC=c(0,0,0)*1/alpha,lambdaC=0.59)

#Stratified Model with est.t=TRUE
model1 <- crrscKM(times=d[,1],causes=d[,2],covariates=d[,4:5],
treatment=d[,3],clusters=d[,6],stratified.model=TRUE,est.t=TRUE,
pre.t=sort(d$time[d$cause==1]),Z0=c(0.5,0.5))

#Unstratified Model with est.t=TRUE
model2 <- crrscKM(times=d[,1],causes=d[,2],covariates=d[,4:5],
treatment=d[,3],clusters=d[,6],stratified.model=FALSE,est.t=TRUE,
pre.t=sort(d$time[d$cause==1]),Z0=c(0.5,0.5))

#Stratified Model with est.t=FALSE
model3 <- crrscKM(times=d[,1],causes=d[,2],covariates=d[,4:5],
treatment=d[,3],clusters=d[,6],stratified.model=TRUE,est.t=FALSE,
pre.t=sort(d$time[d$cause==1]),Z0=c(0.5,0.5))

#Unstratified Model with est.t=FALSE.
#Create dummy variables first
dummy <- model.matrix(~ factor(d[,3]))[,-1]
model4 <- crrscKM(times=d[,1],causes=d[,2],covariates=cbind(d[,4:5],dummy),
clusters=d[,6],stratified.model=FALSE,est.t=FALSE,
pre.t=sort(d$time[d$cause==1]),Z0=c(0.5,0.5))

#Only continuous covariates are available.
model5 <- crrscKM(times=d[,1],causes=d[,2],covariates=d[,4:5],
clusters=d[,6],stratified.model=FALSE,est.t=FALSE,
pre.t=sort(d$time[d$cause==1]),Z0=c(0.5,0.5))
}
