% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.check_ADMB_version}
\alias{.check_ADMB_version}
\title{Check that the  model is compiled with the right version
of ADMB which is 12.0 or later}
\usage{
.check_ADMB_version(model, path = getwd(), min.version = 12, warn = TRUE)
}
\arguments{
\item{model}{Model name without file extension}

\item{path}{Path to model folder, defaults to working
directory. NULL value specifies working directory (default).}

\item{min.version}{Minimum valid version (numeric). Defaults
to 12.0.}

\item{warn}{Boolean whether to throw warnings or not}
}
\value{
Nothing, errors out if either model could not be run
  or the version is incompatible. If compatible nothing
  happens.
}
\description{
Check that the  model is compiled with the right version
of ADMB which is 12.0 or later
}
\details{
Some functionality of packages \pkg{adnuts} is
  imbedded in the ADMB source code so that when a model is
  compiled it is contained in the model executable. If this
  code does not exist adnuts will fail. The solution is to
  update ADMB and recompile the model.
}
