% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.r
\name{abs.Coord1D}
\alias{abs.Coord1D}
\alias{abs.Coord2D}
\alias{abs.Coord3D}
\title{Compute Euclidean norm}
\usage{
\method{abs}{Coord1D}(x)

\method{abs}{Coord2D}(x)

\method{abs}{Coord3D}(x)
}
\arguments{
\item{x}{A \link{Coord2D} class object or \link{Coord2D} class object.}
}
\value{
A numeric vector
}
\description{
\code{abs()} computes the Euclidean norm for \link{Coord2D} class objects and \link{Coord3D} class objects.
}
\examples{
  z <- complex(real = 1:4, imaginary = 1:4)
  p <- as_coord2d(z)
  abs(p) # Euclidean norm
  # Less efficient ways to calculate same Euclidean norms
  sqrt(p * p) # `*` dot product
  distance2d(p, as_coord2d(0, 0, 0))

  # In {base} R `abs()` calculates Euclidean norm of complex numbers
  all.equal(abs(p), abs(z))
  all.equal(Mod(p), Mod(z))

  p3 <- as_coord3d(x = 1:4, y = 1:4, z = 1:4)
  abs(p3)
}
