% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z-affine-settings-docs.r
\name{affine_settings}
\alias{affine_settings}
\title{Compute \code{grid} affine transformation feature viewports and transformation functions}
\usage{
affine_settings(
  xy = data.frame(x = c(0, 0, 1, 1), y = c(1, 0, 0, 1)),
  unit = getOption("affiner_grid_unit", "inches")
)
}
\arguments{
\item{xy}{An R object with named elements \code{x} and \code{y} representing the (x,y) coordinates
of the affine transformed "viewport" one wishes to draw in.
The (x,y) coordinates of the "viewport" should be in
"upper left", "lower left", "lower right", and "upper right" order
(this ordering should be from the perspective of \strong{before}
the "affine transformation" of the "viewport").}

\item{unit}{Which \code{\link[grid:unit]{grid::unit()}} to assume the \code{xy} "x" and "y" coordinates are expressed in.}
}
\value{
A named list with the following group affine transformation feature viewport
and functions settings:\describe{
\item{transform}{An affine transformation function to pass to \code{\link[=affineGrob]{affineGrob()}} or \code{\link[=useGrob]{useGrob()}}.
If \code{getRversion()} is less than \code{"4.2.0"} will instead be \code{NULL}.}
\item{vp}{A \code{\link[grid:viewport]{grid::viewport()}} object to pass to \code{\link[=affineGrob]{affineGrob()}} or \code{\link[=useGrob]{useGrob()}}.}
\item{sx}{x-axis sx factor}
\item{flipX}{whether the affine transformed "viewport" is "flipped" horizontally}
\item{x}{x-coordinate for viewport}
\item{y}{y-coordinate for viewport}
\item{width}{Width of viewport}
\item{height}{Height of viewport}
\item{default.units}{Default \code{\link[grid:unit]{grid::unit()}} for viewport}
\item{angle}{angle for viewport}
}
}
\description{
\code{affine_settings()} computes \code{grid} group affine transformation feature viewport and transformation
function settings given the (x,y) coordinates of the corners of the
affine transformed "viewport" one wishes to draw in.
}
\section{Usage in other packages}{


To avoid taking a dependency on \code{affiner} you may copy the source of \code{affine_settings()}
into your own package under the permissive Unlicense.  Either use
\code{usethis::use_standalone("trevorld/affiner", "standalone-affine-settings.r")} or
copy the file \code{standalone-affine-settings.r} into your \code{R} directory and add \code{grid}
to the \code{Imports} of your \code{DESCRIPTION} file.
}

\examples{
if (require("grid")) {
  grob <- grobTree(rectGrob(gp = gpar(fill = "blue", col = NA)),
                   circleGrob(gp=gpar(fill="yellow", col = NA)),
                   textGrob("RSTATS", gp=gpar(fontsize=32)))
  grid.newpage()
  pushViewport(viewport(width=unit(4, "in"), height=unit(2, "in")))
  grid.draw(grob)
  popViewport()
}
if (require("grid") &&
    getRversion() >= "4.2.0" &&
    isTRUE(dev.capabilities()$transformations)) {
  # Only works if active graphics device supports affine transformations
  # such as `png(type="cairo")` on R 4.2+
  vp_define <- viewport(width=unit(2, "in"), height=unit(2, "in"))
  settings <- affine_settings(xy = list(x = c(1/3, 0/3, 2/3, 3/3),
                                        y = c(2/3, 1/3, 1/3, 2/3)),
                              unit = "snpc")
  affine <- affineGrob(grob,
                       vp_define=vp_define,
                       transform = settings$transform,
                       vp_use = settings$vp)
  grid.newpage()
  grid.draw(affine)
}
if (require("grid") &&
    getRversion() >= "4.2.0" &&
    isTRUE(dev.capabilities()$transformations)) {
  # Only works if active graphics device supports affine transformations
  # such as `png(type="cairo")` on R 4.2+
  settings <- affine_settings(xy = list(x = c(3/3, 2/3, 0/3, 1/3),
                                        y = c(2/3, 1/3, 1/3, 2/3)),
                              unit = "snpc")
  affine <- affineGrob(grob,
                       vp_define=vp_define,
                       transform = settings$transform,
                       vp_use = settings$vp)
  grid.newpage()
  grid.draw(affine)
}
}
\seealso{
Intended for use with \code{\link[=affineGrob]{affineGrob()}} and \code{\link[grid:grid.group]{grid::useGrob()}}.
See \url{https://www.stat.auckland.ac.nz/~paul/Reports/GraphicsEngine/groups/groups.html}
for more information about the group affine transformation feature.
}
