% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{world_to_geotransform}
\alias{world_to_geotransform}
\title{Create geotransform from world vector}
\usage{
world_to_geotransform(x)
}
\arguments{
\item{x}{worldfile parameters, as per \code{\link[=geo_world0]{geo_world0()}}}
}
\value{
geotransform vector, see \code{\link[=geo_transform0]{geo_transform0()}}
}
\description{
Convert world vector (centre offset) and x,y spacing to
geotransform format.
}
\examples{
(wf <- geo_world0(px = c(1, -1), ul = c(0, 0)))
gt <- world_to_geotransform(wf)
geotransform_to_world(gt)
}
