% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{plot.aggTrees}
\alias{plot.aggTrees}
\title{Plot Method for aggTrees Objects}
\usage{
\method{plot}{aggTrees}(x, leaves = get_leaves(x$tree), sequence = FALSE, ...)
}
\arguments{
\item{x}{An \code{aggTrees} object.}

\item{leaves}{Number of leaves of the desired tree. This can be used to plot subtrees.}

\item{sequence}{If \code{TRUE}, the whole sequence of optimal groupings is displayed in a short animation.}

\item{...}{Further arguments from \code{\link[rpart.plot]{prp}}.}
}
\value{
Plots an \code{aggTrees} object.
}
\description{
Plots an \code{aggTrees} object.
}
\details{
Nodes are colored using a diverging palette. Nodes with predictions smaller than the ATE (i.e., the root
prediction) are colored in blue shades, and nodes with predictions larger than the ATE are colored in red
shades. Moreover, predictions that are more distant in absolute value from the ATE get darker shades.
This way, we have an immediate understanding of the groups with extreme GATEs.
}
\examples{
\donttest{## Generate data.
set.seed(1986)

n <- 1000
k <- 3

X <- matrix(rnorm(n * k), ncol = k)
colnames(X) <- paste0("x", seq_len(k))
D <- rbinom(n, size = 1, prob = 0.5)
mu0 <- 0.5 * X[, 1]
mu1 <- 0.5 * X[, 1] + X[, 2]
Y <- mu0 + D * (mu1 - mu0) + rnorm(n)

## Training-honest sample split.
honest_frac <- 0.5
splits <- sample_split(length(Y), training_frac = (1 - honest_frac))
training_idx <- splits$training_idx
honest_idx <- splits$honest_idx

Y_tr <- Y[training_idx]
D_tr <- D[training_idx]
X_tr <- X[training_idx, ]

Y_hon <- Y[honest_idx]
D_hon <- D[honest_idx]
X_hon <- X[honest_idx, ]

## Construct sequence of groupings. CATEs estimated internally.
groupings <- build_aggtree(Y_tr, D_tr, X_tr,
                           Y_hon, D_hon, X_hon)

## Plot.
plot(groupings)
plot(groupings, leaves = 3)
plot(groupings, sequence = TRUE)}

}
\references{
\itemize{
  \item Di Francesco, R. (2022). Aggregation Trees. CEIS Research Paper, 546. \doi{10.2139/ssrn.4304256}.
}
}
\seealso{
\code{\link{build_aggtree}}, \code{\link{inference_aggtree}}
}
\author{
Riccardo Di Francesco
}
