% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{plot_longest_diagonal}
\alias{plot_longest_diagonal}
\title{Plot the longest diagonal of a field}
\usage{
plot_longest_diagonal(
  field,
  n = 8,
  type = "random",
  n_segments = 2,
  distance_field_boundary = 3,
  width_diagonal_path = 2
)
}
\arguments{
\item{field}{An object of class sf representing the field.}

\item{n}{Integer, the number of sample points along the longest diagonal.}

\item{type}{Type of sampling. Default is "random".}

\item{n_segments}{Numeric, the number of segments to divide the longest diagonal (default is 2).}

\item{distance_field_boundary}{Numeric, the distance to buffer the field for creating the boundary (default is 3.0).}

\item{width_diagonal_path}{Numeric, the width to buffer the diagonal path (default is 2.0).}
}
\value{
\itemize{
\item p: A ggplot object showing the field, the buffered field, the buffered line, and the sample points.
\item buffered_line: A sf object representing the buffered line.
\item my_line: A sf object representing the longest diagonal of the field.
\item sample_points: A sf object representing the sampled points.
\item length: A numeric value, representing the length of the longest line.
}
}
\description{
This function takes a field and plots the longest diagonal of the field. The field is divided into segments and points are sampled from these segments.
}
\examples{
library(sf)
my_sf <- st_read(system.file("shape/gfn_schlaege.shp", package="agricolaeplotr"))
st_crs(my_sf) <- 25832
field <- my_sf[my_sf$SCHLAG_NR == 170,]
plot_longest_diagonal(field)
}
