% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.kilch.R
\name{stability.kilch}
\alias{stability.kilch}
\title{Variance of specific adaptive ability}
\usage{
stability.kilch(dataf, res_var, gen_var, env_var, rep_var, plotIt = TRUE)
}
\arguments{
\item{dataf}{the name of the data frame containing the data to analyze.}

\item{res_var}{the response variable.}

\item{gen_var}{the genotypes variable.}

\item{env_var}{the environments variable.}

\item{rep_var}{the replications variable.}

\item{plotIt}{a logical value specifying if plot should be drawn; default is TRUE}
}
\value{
Returns a list of two objects:
\describe{
  \item{ANOVA}{the analysis of variance table}
  \item{scores}{the data frame object of stability analysis results:}
  \itemize{
    \item{\code{mean} mean value}
    \item{\code{OAC} common adaptive ability}
    \item{\code{sigma_ge} variance of GE interaction}
    \item{\code{sigma_CAC} variance of specific adaptive ability}
    \item{\code{S_g} relative stability}
}
}
}
\description{
This function calculates several stability parameters suggested by Kilchevsky & Khotyleva.
}
\examples{
data(exp_data)
stability.kilch(exp_data,"yield","gen","env","rep")
}
\references{
Kilchevsky A.V., Khotyleva L.V. 1989. Genotype and environment in plant breeding. - Minsk: Science and technology. (In Russian).
}
