% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.udach.R
\name{stability.udach}
\alias{stability.udach}
\title{Steadiness of stability index}
\usage{
stability.udach(dataf, res_var, gen_var, env_var, rep_var, plotIt = TRUE)
}
\arguments{
\item{dataf}{the name of the data frame containing the data to analyze.}

\item{res_var}{the response variable.}

\item{gen_var}{the genotypes variable.}

\item{env_var}{the environments variable.}

\item{rep_var}{the replications variable.}

\item{plotIt}{a logical value specifying if plot should be drawn; default is TRUE}
}
\value{
Returns a data frame:
\describe{
  \item{Ust}{the genotype's Steadiness of stability index}
  \item{intensity}{the genotype's intensity value}
  \item{max_val}{the genotype's yield max value}
  \item{min_val}{the genotype's yield min value}
  \item{S_opt}{the genotype's standard deviation at optimal environment}
  \item{S_lim}{the genotype's standard deviation at limited environment}
  \item{I_opt}{the genotype's stability index at optimal environment}
  \item{I_lim}{the genotype's stability index at limited environment}
  }
}
\description{
This function calculates the Udachin's parameters of stability
}
\examples{
data(exp_data)
stability.udach(exp_data,"yield","gen","env","rep")
}
\references{
Udachin R.A. 1990. Methods of assessing the ecological plasticity of wheat varieties. Selection and seed production. 5: 2-6. (In Russian)
}
