% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_bundesland.R
\name{code_bundesland}
\alias{code_bundesland}
\title{Convert the Name or the AGS of a Bundesland}
\usage{
code_bundesland(
  sourcevar,
  origin = "ags",
  destination = "name",
  factor = FALSE
)
}
\arguments{
\item{sourcevar}{Vector which contains the codes or names
to be converted.}

\item{origin}{The following options are available:
\itemize{
\item \code{ags}: AGS (default).
\item \code{name}: Bundesland name.
}}

\item{destination}{The following options are available:
\itemize{
\item \code{ags}: Bundesland AGS (default).
\item \code{iso}: The Bundesland two-character abbreviation.
\item \code{name}: Bundesland name.
\item \code{name_eng}: Bundesland name in English.
}}

\item{factor}{If \code{TRUE} returns ordered factor.}
}
\value{
A character vector.
}
\description{
Convert the Name or the AGS of a Bundesland
}
\details{
This function converts a string of Bundesland names into
the AGS, the standardized (English) name, or the Bundesland abbreviation.

If \code{origin="AGS"}, the first two digits will be used to identify
a Bundesland. It is therefore important that \code{sourcevar} is supplied
as a character vector with a leading zeros if applicable.
}
\examples{
library(dplyr)
data(btw_sn)

btw_sn \%>\% 
 mutate(bl=code_bundesland(district, origin="ags", 
     destination="name"))

}
\seealso{
\code{\link[=format_ags]{format_ags()}} for formatting AGS.
}
