% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ah.R
\name{ah}
\alias{ah}
\title{ah}
\usage{
ah(
  formula = formula(data),
  data = sys.parent(),
  matrix_domain = NULL,
  progbar = FALSE,
  method = "ml_opt",
  scale = TRUE,
  startedge = NULL
)
}
\arguments{
\item{formula}{A formula, the dependent variable must be of type Surv in the survival package..}

\item{data}{A data frame with the covariates mentioned in the formula stored.}

\item{matrix_domain}{A matrix describing the domain to find the maximum likelihood. The default constraint matrix guarantees the hazards to be positive for all possible covariates.}

\item{progbar}{A logical value, shows the progress bar if it is TRUE, hide the progress bar if FALSE, default value is FALSE.}

\item{method}{A string with values "aalen", "ml_opt", "ml_enum", "ml_asc" and "ml_desc". Default value is "ml_opt".  "aalen" represents the Aalen's method.  "ml_opt" is the default method with respect to the default constraint matrix. "ml_enum","ml_asc" and "ml_desc" represents to the naive method, ascending method and descending method. Please check the referee for details.}

\item{scale}{A logical value, scales the input data in the interval [0,1] if it is TRUE. Default value is TRUE.}

\item{startedge}{a vector which satisfies the domain condition. Only used for the ascending method.}
}
\value{
A data frame, containing the coefficients (beta) at each time point and the cumulative beta at each time point.
}
\description{
This function offers the methods to fit the additive hazards model, including Aalen's method and Maximum likelihood method.
}
\examples{
X1 = rnorm(100); X2 = rnorm(100)
Survival_Time = rep(0,100)
U = runif(100,min =0, max =1)
for (i in 1:100){Survival_Time[i] = sqrt((-2*log(U[i]))/(0.3*X1[i] + 0.7*X2[i]))}
tcens = runif(100, 2.5, 7.5)
time =  pmin(Survival_Time, tcens)
event = as.numeric(Survival_Time<=tcens)
Data = data.frame(time = time, X1 = X1, X2 = X2, event = event)

Result = ah(Surv(time = time, event = event)~ X1 + X2, Data)

}
\references{
Chengyuan Lu, Jelle Goeman, Hein Putter 
Maximum likelihood estimation in the additive hazards model
arXiv:2004.06156
}
