% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/graph.R
\docType{methods}
\name{graph_prune}
\alias{graph_prune}
\alias{graph_prune-method}
\alias{graph_prune,igraph-method}
\title{Prune a Graph}
\usage{
graph_prune(object, ...)

\S4method{graph_prune}{igraph}(
  object,
  reduce = TRUE,
  remove_multiple = TRUE,
  remove_loops = TRUE,
  ...
)
}
\arguments{
\item{object}{An \pkg{igraph} object (typically returned by
\code{\link[=graph_create]{graph_create()}}).}

\item{...}{Currently not used.}

\item{reduce}{A \code{\link{logical}} scalar: should transitive reduction be performed?
Only used if \code{object} is a directed acyclic graph.}

\item{remove_multiple}{A \code{\link{logical}} scalar: should multiple edges be
removed?}

\item{remove_loops}{A \code{\link{logical}} scalar: should loop edges be removed?}
}
\value{
An \pkg{igraph} graph object.
}
\description{
Removes redundant relations from a graph.
}
\note{
Experimental.

The \pkg{igraph} and \pkg{relations} packages need to be installed on your
machine.
}
\examples{
if (requireNamespace("igraph", quietly = TRUE) &&
    requireNamespace("relations", quietly = TRUE)) {
  ## Seven intervals
  int <- intervals(
    start = c(1, 2, 3, 6, 9, 13, 17),
    end = c(7, 4, 15, 14, 11, 18, 19),
    calendar = CE(),
    names = c("A", "B", "C", "D", "E", "F", "G")
  )

  ## Interval graph
  g <- graph_create(int, type = "interval")
  plot(g)

  ## Stratigraphic graph
  g <- graph_create(int, type = "strati")
  g <- graph_prune(g) # Remove redundant relations
  plot(g, layout = igraph::layout_with_sugiyama)
}
}
\seealso{
Other graph tools: 
\code{\link{graph_create}()}
}
\author{
N. Frerebeau
}
\concept{graph tools}
