% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/altfuel_api.R
\name{alt_fuel_near}
\alias{alt_fuel_near}
\title{Check For Alternate Fuel Nearby}
\usage{
alt_fuel_near(api_key, location = NULL, miles = 5, fuel_type = NULL)
}
\arguments{
\item{api_key}{Character. An authorized API key for the NREL API service. API keys can be requested at \url{https://developer.nrel.gov/signup/}}

\item{location}{A free-form input describing the address of the location. This may include the address given in a variety of formats, such as: street, city, state, postal code, etc.}

\item{miles}{Numeric. The radius (in miles) around the search location to search for stations within. An explicit radius of up to 500.0 miles may be passed in, or the special infinite string may be passed in to find the nearest stations regardless of distance. Defaults to 5.}

\item{fuel_type}{Optional. Filter results by a specific fuel type. Options: BD (biodiesel), CNG (compressed natural gas), ELEC (electric), E85 (ethanol/E85), HY (hydrogen), LNG (liquified natural gas), LPG, (propane).}
}
\value{
Logical value indicating whether at least one alternative fuel station exists for the given fuel in the given radius around the specified location.
}
\description{
Check For Alternate Fuel Nearby
}
\examples{
\dontrun{
alt_fuel_near(MY_API_KEY, "Nome, AK")
alt_fuel_near(MY_API_KEY, "Raleigh, NC", radius = 10, fuel_type = "LNG")
}
}
