% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{explore_plot}
\alias{explore_plot}
\title{Plot for compounds divergence in reports}
\usage{
explore_plot(data, type = "all", counts = NULL)
}
\arguments{
\item{data}{an tibble obtained by \code{amanida_read} w/o names checked by \code{check_names}}

\item{type}{select the subset of data to plot. Options are:
\itemize{
\item "all": all data will be displayed
\item "sub": only data over counts value will be displayed. Need counts value.
\item "mix": will display data over count value and elements with reports in both trends.Need counts value.
}}

\item{counts}{value of vote-counting cut-off. Will be only displayed data over the cut-off.}
}
\value{
a ggplot bar-plot showing the sum of votes for each compound divided by the trend
}
\description{
\code{explore_plot} creates a bar-plot showing the votes divided in up-regulated and down-regulated and the global result for each compound.
}
\details{
Sum of votes divided by trend are plotted, then is obtained the total result by compound summing both trends.
}
\examples{
data("sample_data")

explore_plot(sample_data, type = "mix", counts = 1)

}
