% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldZgbme.R
\name{ldZgbme}
\alias{ldZgbme}
\title{log density for GBME models}
\usage{
ldZgbme(Z, Y, llYZ, EZ, rho, s2 = 1)
}
\arguments{
\item{Z}{n X n latent relational matrix following an AMEN model}

\item{Y}{n X n observed relational matrix}

\item{llYZ}{a vectorizable function taking two arguments, y and z. See details below.}

\item{EZ}{n X n mean matrix for \code{Z} based on AMEN model (including additive effects)}

\item{rho}{dyadic correlation in AMEN model for \code{Z}}

\item{s2}{residual variance in AMEN model for \code{Z}}
}
\value{
a symmetric matrix where entry i,j is proportional 
to the log conditional bivariate density of \code{z[i,j],z[j,i]}.
}
\description{
Calculation of the log conditional density of the 
latent AMEN matrix \code{Z} given observed data \code{Y}.
}
\details{
This function is used for updating dyadic pairs of 
the latent variable matrix \code{Z} based on \code{Y} and 
an AMEN model for \code{Z}. The function \code{llYZ} specifies 
the log likelihood for each single \code{z[i,j]} based on 
\code{y[i,j]}, that is, \code{llYZ} gives the log probability 
density (or mass function) of \code{y[i,j]} given \code{z[i,j]}.
}
\examples{
## For (overdispersed) Poisson regression, use
llYZ<-function(y,z){ dpois(y,z,log=TRUE) } 

}
\author{
Peter Hoff
}
