% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acccept_rate.R
\name{accept_rate}
\alias{accept_rate}
\title{Estimate the local acceptance rate}
\usage{
accept_rate(mc_limit_dstr, dir, null_quants, norms_idx = 2, norm_type = "lp")
}
\arguments{
\item{mc_limit_dstr}{MC draws from an estimate of the
(centered) limiting distribution. Data where columns correspond
to different covariates, and rows are independent observations.}

\item{dir}{a vector in the direction for which we wish to estimate power.}

\item{null_quants}{the cutoff values for the distribution under the null
for each lp norm.}

\item{norms_idx}{the index of the norms to be used (ideally integers).}

\item{norm_type}{string indicating the class of norms to select over
(sum of squares ("ssq") or lp norms ("lp") are currently supported).}
}
\value{
The estimated acceptance rate for the specified norm-based test
for a given local alternative.
}
\description{
This a helper function used to estimate the acceptance rate for a
simple norm based test under a sequence of local alternatives in
a given direction given the estimated limiting distribution.
}
