% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_oth_pvals.R
\name{add_oth_pvals}
\alias{add_oth_pvals}
\title{Add Other p-values}
\usage{
add_oth_pvals(test_result)
}
\arguments{
\item{test_result}{The test result from mv_pn_test}
}
\value{
The same test result object with additional p-values for
the Liu and Xie (2021) test (liu_xie_pvalue) and the Bonferroni based
test (bonf_pvalue)
}
\description{
Add pvalues for the Liu and Xie and Bonferroni based
tests using the estimated parameter estimates and
corresponding standard errors.
}
\examples{
## NOTE: More monte-carlo samples should be taken are taken here.  This is
## only done to lower computation time.
set.seed(10)
test <- mv_pn_test(data.frame(y = rnorm(100), x = rnorm(100)),
                   ic.pearson, test.control(n_peld_mc_samples = 20,
                                            ts_ld_bs_samp = 20))
test_with_extra <- add_oth_pvals(test)
test_with_extra[c("pvalue", "liu_xie_pvalue", "bonf_pvalue")]
}
