% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_gam_star.R
\name{calc_gam_star}
\alias{calc_gam_star}
\title{A helper function for \code{mv_pn_test}, calculating the test statistic
for both the vector of parameter estimates, and the draws from
the corresponding estimated limiting distribution.}
\usage{
calc_gam_star(obs_data, param_est, control, lm_dst = NULL, return_lmd = FALSE)
}
\arguments{
\item{obs_data}{The observed data used to calculate the test statistic.
Each row is an observation and each column corresponds to either the
outcome (first column) or a covariate.}

\item{param_est}{A function used to estimate both they parameter of interest
and the IC of the corresponding estimator.}

\item{control}{A list providing control arguments for the function.}

\item{lm_dst}{A list containing an estimate of the limiting distribution and
corresponding norm specific test cutoffs if it is provided.}

\item{return_lmd}{Boolean for whether to return the estimated
limiting distribution.}
}
\value{
Calculated test statistic for the given data.
}
\description{
A helper function for \code{mv_pn_test}, calculating the test statistic
for both the vector of parameter estimates, and the draws from
the corresponding estimated limiting distribution.
}
