% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ua_FRS.R
\name{ua_FRS}
\alias{ua_FRS}
\title{Updated Alternative Fistula Risk Score (ua-FRS)}
\usage{
ua_FRS(my_data)
}
\arguments{
\item{my_data}{A data frame containing the columns Sex (Female = 0, Male = 1), Texture ("soft = 1" or "hard = 0"), PD_size Numeric (Pancreatic duct diameter in millimeters), and BMI Numeric (Body mass index in kg/m²).}
}
\value{
A modified data frame with the calculated alternative Fistula Risk Score (FRS) and risk classification of CR-POPF following pancreatoduodenectomy. Returns NA for cases with missing values.
}
\description{
Calculates the alternative Fistula Risk Score (FRS) based on gland Texture, pancreatic duct diameter, BMI, and Sex.
Objective is to validate and optimize the alternative Fistula Risk Score (ua-FRS) specifically for patients undergoing minimally invasive pancreatoduodenectomy (MIPD) using data from a comprehensive pan-European cohort.
Visit \url{https://www.evidencio.com/models/show/1408} for more information.
}
\details{
This function calculates the risk of Postoperative Pancreatic Fistula (POPF) following pancreatoduodenectomy using the specified parameters:
\itemize{
\item \code{Texture : } Nature of pancreatic texture (Not soft = 0 or Soft = 1)
\item \code{BMI :} Body mass index in Kg/m²
\item \code{PD_size :} Size of the pancreatic duct in mm (truncated to 5)
\item \code{Sex :} Sex (Female = 0, Male = 1)
}
}
\examples{
my_data <- data.frame(
  ID = 1:4,
  Sex = c(0, 0, 1, 1),
  Texture = c(0, 1, 0, 0),
  BMI = c(22, 25, 30, 20),
  PD_size = c(5, 10, 1, 2)
)
ua_FRS(my_data)
}
\references{
Mungroop et al. (2019) \url{doi:10.1097/SLA.0000000000003234}.
}
